#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static float Matrix[16], Matrix2[16], WorldMatrix[16], WorldMatrix2[16];
static Vector Pos[49];
static Vector Pos2[49];
static DWORD Mask1R[49], Mask2R[49];
static DWORD Mask1G[49], Mask2G[49];
static DWORD Mask1B[49], Mask2B[49];

void LInit_Sprites()
{
	int Cpt1, Cpt2, Cpt3=0;

	PrepareTextureFromArray(g_PicFlare2, 256, 256, &g_TextureFlare2);
	for(Cpt1=0;Cpt1<7;Cpt1++)
	{
		for(Cpt2=0;Cpt2<7;Cpt2++)
		{
			Pos[Cpt3].x = (Cpt1-3.5) * 600;
			Pos[Cpt3].y = 600.f * cos(Cpt2/7.f*PI2);
			Pos[Cpt3].z = 600.f * sin(Cpt2/7.f*PI2);

			Pos2[Cpt3].x = (Cpt1-5) * 600 + 300;
			Pos2[Cpt3].y = 900.f * cos(Cpt2/7.f*PI2);
			Pos2[Cpt3].z = 900.f * sin(Cpt2/7.f*PI2);
			
			Cpt3++;
		}
	}

	for(Cpt1=0;Cpt1<49;Cpt1++)
	{
		switch(Cpt1%3)
		{
		case 0:
			Mask1R[Cpt1] = 0xff; Mask1G[Cpt1] = 0; Mask1B[Cpt1] = 0;
			Mask2R[Cpt1] = 0; Mask2G[Cpt1] = 0xff; Mask2B[Cpt1] = 0;
			break;
		case 1:
			Mask1R[Cpt1] = 0; Mask1G[Cpt1] = 0xff; Mask1B[Cpt1] = 0;
			Mask2R[Cpt1] = 0; Mask2G[Cpt1] = 0; Mask2B[Cpt1] = 0xff;
			break;
		case 2:
			Mask1R[Cpt1] = 0; Mask1G[Cpt1] = 0; Mask1B[Cpt1] = 0xff;
			Mask2R[Cpt1] = 0xff; Mask2G[Cpt1] = 0; Mask2B[Cpt1] = 0;
			break;
		}
	}
}

void QInit_Sprites()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grDepthMask(FXFALSE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grConstantColorValue(255);
	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureFlare2);
	SelectTexture(g_TextureFlare2);
}

void Effect_Sprites()
{
	int Cpt1;
	DWORD dwSize, dwTmp;
	static DWORD Old = 0;
	static BOOL bDrawMe = FALSE;

	grColorMask(FXTRUE, FXTRUE);

	if (g_demostate.TickInEffect<10000-5000/6)
	//if ((g_demostate.TickInEffect<5000)&&((Old+0<g_demostate.TickInEffect)||(bDrawMe)))
	{
	  /*		if (bDrawMe==FALSE)
			{
			bDrawMe = TRUE;
			Old = g_demostate.TickInEffect;
			}
			else
			{
			bDrawMe = FALSE;
			}*/
	  //dwSize = 192+64*CosTable[(g_demostate.TickInEffect*4)&8191];
	  dwSize = 224;
	  grConstantColorValue(10<<24);
	  grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
			       GR_BLEND_ONE, GR_BLEND_ZERO);
	  grColorCombine(GR_COMBINE_FUNCTION_ZERO,
			 GR_COMBINE_FACTOR_ZERO,
			 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	  grDrawTriangle(&Fond1, &Fond2, &Fond3);
	  grDrawTriangle(&Fond3, &Fond4, &Fond1);
	}
	else
	{
		dwSize = 256;
	}

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	if (g_demostate.TickInEffect<1024)
	{
		dwTmp = g_demostate.TickInEffect/4;
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
	}
	else
	{
		dwTmp = 0xff;
		grConstantColorValue(0xffffff);
	}

	BeIdentityMatrix(WorldMatrix);
	RotateXMatrix(WorldMatrix2, WorldMatrix, g_demostate.TickInEffect*2);
	RotateYMatrix(WorldMatrix, WorldMatrix2, g_demostate.TickInEffect*2);
	RotateZMatrix(WorldMatrix2, WorldMatrix, g_demostate.TickInEffect*2);
	for(Cpt1=0;Cpt1<49;Cpt1++)
	{
		BeIdentityMatrix(Matrix);
		TranslateMatrix(Matrix, Pos[Cpt1].x, Pos[Cpt1].y, Pos[Cpt1].z);
		MulMatrix(Matrix2, WorldMatrix2, Matrix);
		Draw3dSprite(dwSize, dwSize, Matrix2);
	}

	BeIdentityMatrix(WorldMatrix);
	RotateXMatrix(WorldMatrix2, WorldMatrix, -g_demostate.TickInEffect*2);
	RotateYMatrix(WorldMatrix, WorldMatrix2, g_demostate.TickInEffect*2);
	RotateZMatrix(WorldMatrix2, WorldMatrix, g_demostate.TickInEffect*2);
	for(Cpt1=0;Cpt1<49;Cpt1++)
	{
		BeIdentityMatrix(Matrix);
		TranslateMatrix(Matrix, Pos2[Cpt1].x, Pos2[Cpt1].y, Pos2[Cpt1].z);
		MulMatrix(Matrix2, WorldMatrix2, Matrix);
		Draw3dSprite(dwSize, dwSize, Matrix2);
	}

	grColorMask(FXFALSE, FXFALSE);
}

void ByeBye_Sprites()
{
	FreeTexture(&g_TextureFlare2);
	grDepthMask(FXTRUE);
	grColorMask(FXTRUE, FXTRUE);
}
